/* eslint-disable no-unused-vars */
import { useEffect, useState } from "react";
import { useLocation, useNavigate } from "react-router-dom";
import Login from "../login/Login";
import SignUp from "../signup/SignUp";
import { TfiReload } from "react-icons/tfi";
import { FaEye, FaEyeSlash, FaHome, FaRegUserCircle } from "react-icons/fa";
import {
  defaultSetting,
  getPromotionsOffer,
  myBetList,
  walletBalance,
} from "../../redux/_reducers/_reducers";
import { useDispatch, useSelector } from "react-redux";
import ResetPassword from "../resetPassword/ResetPassword";
import { toast } from "react-toastify";
import CopyReferCode from "../../views/copyReferCode/CopyReferCode";
import Translator from "../translater/Translator";
import { IoLogOutOutline } from "react-icons/io5";
import Promotions from "../promotions/Promotions";
import { LuAlarmClock } from "react-icons/lu";
import { SlTrophy } from "react-icons/sl";
import { BsPinFill } from "react-icons/bs";
import LanguageModal from "../languageModal/LanguageModal";
import Turnover from "../Turnover/Turnover";
import DepositWithdrawl from "../depositWithdrawlModal/DepositWithdrawl";

const AppFooter = () => {
  const location = useLocation();
  // const hideFooterRoutes = [`/inplay/4`];
  const shouldShowFooter =
    location.pathname.startsWith("/inplay") ||
    location.pathname.startsWith("/view-details");

  // console.log(window.location, "dddddddddds");
  const navigate = useNavigate();
  const dispatch = useDispatch();
  const [toggleLogin, setToggleLogin] = useState(false);
  const [togglePassword, setTogglePassword] = useState(false);
  const [toggleTurnover, setToggleTurnover] = useState(false);
  const [showLogin, setShowLogin] = useState(false);
  const [showLanguage, setShowLanguage] = useState(false);
  const [myAccount, setMyAccount] = useState(false);
  const [toggleSignUp, setToggleSignUp] = useState(false);
  const { defaultSettingData } = useSelector((state) => state.authentication);
  const [toggleRefer, setToggleRefer] = useState(false);
  const [isRotating, setIsRotating] = useState(false);
  const [hideBalance, setHideBalance] = useState(true);
  const [depositwithdraw, setDepositWithdraw] = useState(false);

  const [showPromotions, setShowPromotions] = useState(false);

  const handleHideBalance = () => {
    setHideBalance((prev) => !prev);
  };
  const [balance, setBalance] = useState({
    coins: "",
    exposure: "",
    profitLoss: "",
  });

  const handlePasswordclose = () => {
    setTogglePassword(false);
  };

  const handleResetPassword = () => {
    setTogglePassword((prev) => !prev);
    setMyAccount(false);
    // setToggleLogin(false);
    setShowLogin(false);
    setToggleSignUp(false);
  };

  const handleTurnOverModal = () => {
    setToggleTurnover((prev) => !prev);
    setTogglePassword(false);
    setMyAccount(false);
    // setToggleLogin(false);
    setShowLogin(false);
    setToggleSignUp(false);
  };

  const handlePromotions = () => {
    setShowPromotions((prev) => !prev);
    dispatch(getPromotionsOffer());
  };

  const handleLogin = () => {
    setToggleLogin((prev) => !prev);
    setToggleSignUp(false);
    setShowLogin((prev) => !prev);
    setShowLanguage(false);
  };

  const handleSignUp = () => {
    setToggleSignUp((prev) => !prev);
    setToggleLogin(false);
    setShowLanguage(false);
  };

  const handleLanguage = () => {
    setShowLanguage((prev) => !prev);
    setToggleSignUp(false);
    setToggleLogin(false);
  };

  const handleWithdrawalClick = () => {
    setIsRotating(true);

    setTimeout(() => {
      setIsRotating(false);
    }, 1000);

    dispatch(walletBalance());
  };

  useEffect(() => {
    dispatch(defaultSetting());
  }, []);
  // const handleLogin = () => {

  // };
  // const handleSignUp = () => {
  //   setToggleSignUp((prev) => !prev);
  //   setToggleLogin(false);
  // };

  const handleReferModal = () => {
    setToggleRefer((prev) => !prev);
  };

  const handleReferClose = () => {
    setToggleRefer(false);
  };

  useEffect(() => {
    setTimeout(() => {
      let Balance = JSON.parse(localStorage.getItem("clientBalance"));
      let clientExposure = JSON.parse(localStorage.getItem("clientExposure"));
      let clientProfitLoss = JSON.parse(
        localStorage.getItem("clientProfitLoss")
      );
      setBalance({
        coins: Balance,
        exposure: clientExposure,
        profitLoss: clientProfitLoss,
      });
    }, 1000);
  }, [balance]);

  const handleMyAccount = () => {
    setMyAccount((prev) => !prev);
  };

  const handleDWModal = () => {
    setDepositWithdraw((prev) => !prev)
  };

  const handleBets = async (e) => {
    navigate("/pending-bets");
    setMyAccount(false);
  };

  const token = JSON.parse(localStorage?.getItem("token"));

  return (
    <>
      <div className="flex w-full h-full ">
        {!token && (
          <div className="grid grid-cols-3 w-full h-full bg-white">
            {/* <Translator /> */}
            <div
              onClick={() => {
                handleLanguage();
              }}
              className="flex justify-center items-center gap-2 bg-[#d7e3f0]">
              <img src="/footer_images/IN.png" className="w-[34px] h-[34px]" />
              <span className="flex flex-col text-[#333] font-[700] text-[13px] -space-y-1">
                <p>INR</p>
                <p>English</p>
              </span>
            </div>

            <div
              className="flex w-full h-full text-gray-900 text-[15px] font-bold  justify-center items-center"
              onClick={() => {
                handleSignUp();
              }}
            >
              Sign Up
            </div>

            <div
              className="flex w-full  h-full text-white text-[15px] font-bold bg-[var(--primary)]  justify-center items-center"
              onClick={() => {
                handleLogin();
              }}
            >
              Login
            </div>
          </div>
        )}

        {token && !shouldShowFooter && (
          <div className="w-full overflow-auto bg-[#111111] grid grid-cols-4 h-full">
            <div
              onClick={() => {
                navigate("/dashboard");
              }}
              className="w-full flex flex-col justify-center items-center h-full "
            >
              <img src="/footer_images/toolbar-icon-home.svg" />
              <span className="text-white text-[12px]">Home</span>
            </div>
            <div
              onClick={() => {
                handleMyAccount();
              }}
              className="w-full flex flex-col justify-center items-center h-full "
            >
              <img src="/footer_images/toolbar-icon-mine.svg" />
              <span className="text-white text-[12px]">My Account</span>
            </div>
            <div
              // onClick={() => {
              //   navigate("/deposit");
              // }}
              onClick={() => {
                handleDWModal();
              }}
              className="w-full flex flex-col justify-center items-center h-full "
            >
              <img src="/footer_images/toolbar-icon-deposit.svg" />
              <span className="text-white text-[12px]">Deposit</span>
            </div>
            <div
              onClick={() => {
                handlePromotions();
              }}
              className="w-full flex flex-col justify-center items-center h-full "
            >
              <img src="/footer_images/toolbar-icon-promotion.svg" />
              <span className="text-white text-[12px]">Promotions</span>
            </div>
          </div>
        )}

        {token && shouldShowFooter && (
          <section className="mobile-menu fixed bottom-0 h-[50px] w-full lg:hidden block bg-white shadow z-50">
            <ul className="flex items-center flex-wrap justify-center">
              <div onClick={() => { navigate("/casino"); setMyAccount(false) }} className="text-center flex-1 mobile-menu-before">
                <div className="flex flex-col items-center justify-center text-gray-700 hover:text-[#2d5974]">
                  <img className="h-10" src="/footerimages/promot.svg" />
                </div>
              </div>

              <li onClick={() => { navigate("/dashboard"); setMyAccount(false) }} className="text-center flex-1">
                <div className="flex flex-col items-center justify-center text-gray-700 hover:text-[#2d5974]">
                  <div className="flex justify-center items-center flex-col text-white">
                    <FaHome />
                    <span className="text-xs mt-1">Home</span>
                  </div>
                </div>
              </li>

              <li className="text-center flex-1">
                <div onClick={() => { navigate("/inplay/4"); setMyAccount(false) }} className="flex flex-col items-center justify-center text-gray-700 hover:text-[#2d5974]">
                  <div className="flex justify-center items-center flex-col text-white">
                    <LuAlarmClock />
                    <span className="text-xs mt-1">In-Play</span>
                  </div>
                </div>
              </li>

              <li className="text-center flex-1">
                <div onClick={() => { navigate("/inplay/4"); setMyAccount(false) }} className="flex flex-col items-center justify-center text-gray-700 hover:text-[#2d5974] cursor-pointer">
                  <div className="flex justify-center items-center flex-col text-white">
                    <SlTrophy />
                    <span className="text-xs mt-1">Sports</span>
                  </div>
                </div>
              </li>

              <li className="text-center flex-1">
                <div onClick={handleMyAccount} className="flex flex-col items-center justify-center text-gray-700 hover:text-[#2d5974] cursor-pointer">
                  <div className="flex justify-center items-center flex-col text-white">
                    <FaRegUserCircle />
                    <span className="text-xs mt-1">Acco...</span>
                  </div>
                </div>
              </li>
            </ul>
          </section>
        )}

        {depositwithdraw && (
          <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)] overflow-y-auto  border text-black   rounded-md"
            >
              <DepositWithdrawl handleClose={handleDWModal} />
            </div>
          </div>
        )}

        {showPromotions && (
          <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border  text-black   rounded-md"
            >
              <Promotions handlePromotions={handlePromotions} />
            </div>
          </div>
        )}

        {showLogin && (
          <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border  text-black   rounded-md"
            >
              <Login handleLogin={handleLogin} handleSignUp={handleSignUp} />
            </div>
          </div>
        )}

        {toggleSignUp && (
          <div className="fixed inset-0 backdrop-blur-[3px] z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white relative  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]   border  text-black   rounded-md"
            >
              <SignUp handleSignUp={handleSignUp} handleLogin={handleLogin} />
            </div>
          </div>
        )}

        {myAccount && (
          <div className="fixed z-[1]  inset-0 backdrop-blur-[3px] bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  overflow-y-auto overflow-x-hidden !bg-white relative  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)] border text-black rounded-md"
            >
              <div className="relative">
                <img
                  src="/footer_images/member-header-bg.png"
                  className="h-32 w-full"
                  alt=""
                />
                <div
                  onClick={() => {
                    handleMyAccount();
                  }}
                  className="absolute -top-10 h-20 w-20 rounded-full text-[18px] flex justify-center pt-8 pr-5 items-center bg-white -right-6"
                >
                  X
                </div>
              </div>
              <div className="w-[95%] m-auto h-full mb-4">
                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className="h-16 p-2 w-full flex rounded-sm text-[var(--primary)] justify-between items-center bg-white"
                >
                  <div className="flex justify-center items-center ">
                    Main Wallet{" "}
                    <TfiReload
                      onClick={() => {
                        handleWithdrawalClick();
                      }}
                      className={`ml-1 ${isRotating ? "rotate-animation" : ""}`}
                    />
                    {hideBalance ? (
                      <FaEye
                        onClick={() => {
                          handleHideBalance();
                        }}
                        size={18}
                        className="mx-2"
                      />
                    ) : (
                      <FaEyeSlash
                        onClick={() => {
                          handleHideBalance();
                        }}
                        size={18}
                        className="mx-2"
                      />
                    )}{" "}
                  </div>
                  <span className="text-orange-500 text-[18px]">
                    {" "}
                    &#8377; {hideBalance ? balance?.coins : "******"}
                  </span>
                </div>

                <style>
                  {`@keyframes rotate {
              0% { transform: rotate(0deg); }
              100% { transform: rotate(360deg); }
            }
            
            .rotate-animation {
              animation: rotate 1s linear;
            }`}
                </style>

                {/* Funds */}

                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className=" mt-2 w-full  rounded-sm    bg-white"
                >
                  <div className="w-full border-b py-2 px-2 ">
                    <div className="border-l-4  border-[var(--primary)]  px-2 text-[14px]">
                      Funds
                    </div>{" "}
                  </div>
                  <div className="grid grid-cols-3">
                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/balance-transfer");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-profile.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2 whitespace-nowrap">Balance Transfer</span>
                      </div>
                    </div>

                    <div
                      onClick={() => {
                        handleMyAccount();
                        handleDWModal();
                        // navigate("/deposit");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/deposit.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Deposit</span>
                      </div>
                    </div>
                    <div
                      onClick={() => {
                        handleMyAccount();
                        handleDWModal();
                        // navigate("/withdrawal");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/withdrawal.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Withdrawal</span>
                      </div>
                    </div>
                  </div>
                </div>

                {/* History */}

                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className=" mt-2 w-full  rounded-sm    bg-white"
                >
                  <div className="w-full border-b py-2 px-2 ">
                    <div className="border-l-4  border-[var(--primary)]  px-2 text-[14px]">
                      History
                    </div>{" "}
                  </div>
                  <div className="grid grid-cols-3">
                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/bet-history");
                      }}
                      className="flex whitespace-nowrap flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-records.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Betting Records</span>
                      </div>
                    </div>

                    <div
                      onClick={handleBets}
                      className="flex whitespace-nowrap flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-turnover.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Pending Bets</span>
                      </div>
                    </div>
                    {/* <div className="flex flex-col justify-center items-center">
                            <img src="/headerImages/turnover.png" className="h-[50px] py-2" alt="" />
                            <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                                <span className="p-2">Turn Over</span>
                            </div>
                        </div> */}
                    {/* <div onClick={() => {
                    handleMyAccount()
                    navigate('/deposit-withdraw')
                  }
                  } className="flex flex-col justify-center items-center">
                    <img src="/headerImages/bet-records.png" className="h-[50px] py-2" alt="" />
                    <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                      <span className="p-2">D/W Transactions </span>
                    </div>
                  </div> */}

                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/profit-loss");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/bet-records.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Profit&Loss </span>
                      </div>
                    </div>
                  </div>
                </div>

                {/* profile */}

                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className=" mt-2 w-full  rounded-sm    bg-white"
                >
                  <div className="w-full border-b py-2 px-2 ">
                    <div className="border-l-4  border-[var(--primary)]  px-2 text-[14px]">
                      Profile
                    </div>{" "}
                  </div>
                  <div className="grid grid-cols-3">
                    <div
                      onClick={() => {
                        handleResetPassword();
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/resetpasswords.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Reset Password</span>
                      </div>
                    </div>

                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/profile");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-profile.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Profile</span>
                      </div>
                    </div>

                    <div
                      onClick={() => {
                        handleReferModal();
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-referral.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Refer Bonus</span>
                      </div>
                    </div>
                    {/* <div className="flex flex-col justify-center items-center">
                            <img src="/headerImages/turnover.png" className="h-[50px] py-2" alt="" />
                            <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                                <span className="p-2">Turn Over</span>
                            </div>
                        </div>
                        <div className="flex flex-col justify-center items-center">
                            <img src="/headerImages/bet-records.png" className="h-[50px] py-2" alt="" />
                            <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                                <span className="p-2">Transaction </span>
                            </div>
                        </div> */}
                  </div>
                </div>

                {/*Verifiaction */}

                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className=" mt-2 w-full  rounded-sm    bg-white"
                >
                  <div className="w-full border-b py-2 px-2 ">
                    <div className="border-l-4  border-[var(--primary)]  px-2 text-[14px]">
                      Statements
                    </div>{" "}
                  </div>
                  <div className="grid grid-cols-3 ">
                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/account-statement");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-records.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2 whitespace-nowrap">
                          Account statements
                        </span>
                      </div>
                    </div>
                    <div
                      onClick={() => {
                        handleMyAccount();
                        navigate("/deposit-withdraw");
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/bet-records.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2 whitespace-nowrap">
                          D/W Transactions{" "}
                        </span>
                      </div>
                    </div>
                    <div
                      onClick={() => {
                        handleTurnOverModal();
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-turnover.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-2">Turnover</span>
                      </div>
                    </div>
                    {/* <div className="flex flex-col justify-center items-center">
                            <img src="/headerImages/turnover.png" className="h-[50px] py-2" alt="" />
                            <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                                <span className="p-2">Turn Over</span>
                            </div>
                        </div>
                        <div className="flex flex-col justify-center items-center">
                            <img src="/headerImages/bet-records.png" className="h-[50px] py-2" alt="" />
                            <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                                <span className="p-2">Transaction </span>
                            </div>
                        </div> */}
                  </div>
                </div>

                <div
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className=" mt-2 w-full  rounded-sm    bg-white"
                >
                  <div className="w-full border-b py-2 px-2 ">
                    <div className="border-l-4  border-[var(--primary)]  px-2 text-[14px]">
                      Contact US
                    </div>{" "}
                  </div>
                  <div className="grid grid-cols-3">
                    <div
                      onClick={() => {
                        const telegramLink = defaultSettingData?.find(
                          (data) => data?.key === "site.telegram"
                        )?.value;

                        if (telegramLink) {
                          window.open(telegramLink, "_blank");
                        } else {
                          toast.success("Telegram link not found");
                        }
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-telegram.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-1">Telegram </span>
                      </div>
                    </div>
                    <div
                      onClick={() => {
                        const telegramLink = defaultSettingData?.find(
                          (data) => data?.key === "site.instagram"
                        )?.value;

                        if (telegramLink) {
                          window.open(telegramLink, "_blank");
                        } else {
                          toast.success("Telegram link not found");
                        }
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-customer.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-1">Instagram</span>
                      </div>
                    </div>
                    <div
                      onClick={() => {
                        const telegramLink = defaultSettingData?.find(
                          (data) => data?.key === "site.facebook"
                        )?.value;

                        if (telegramLink) {
                          window.open(telegramLink, "_blank");
                        } else {
                          toast.success("Telegram link not found");
                        }
                      }}
                      className="flex flex-col justify-center items-center"
                    >
                      <img
                        src="/headerImages/icon-facebook-messenger.png"
                        className="h-[50px] py-2"
                        alt=""
                      />
                      <div className="flex  bg-[#f5f5f5] w-full justify-center items-center ">
                        <span className="p-1">Facebook </span>
                      </div>
                    </div>
                  </div>
                </div>

                <div
                  onClick={() => {
                    localStorage.clear();
                    window.location.reload();
                  }}
                  style={{ boxShadow: "2px 2px 10px gray" }}
                  className="w-full  rounded-sm bg-white p-4 my-2 flex justify-center items-center text-[var(--light-header)] gap-1"
                >
                  <IoLogOutOutline className="" size={22} />
                  <p className="text-[14px] font-[600]">Logout</p>
                </div>
              </div>
            </div>
          </div>
        )}

        {toggleTurnover && (
          <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border text-black   rounded-md"
            >
              <Turnover handleClose={handleTurnOverModal} />
            </div>
          </div>
        )}

        {togglePassword && (
          <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border text-black   rounded-md"
            >
              <ResetPassword
                handleSignUp={handleSignUp}
                handleLogin={handleLogin}
                handleResetPassword={handleResetPassword}
                handleClose={handlePasswordclose}
                setTogglePassword={setTogglePassword}
              />
            </div>
          </div>
        )}

        {toggleRefer && (
          <div className="fixed inset-0 backdrop-blur-[6px] !z-50 bg-transparent flex justify-center items-center">
            <div
              onClick={(e) => e.stopPropagation()}
              className=" animate-slideInFromBottom  !bg-white border text-black px-5 rounded-md"
            >
              <CopyReferCode
                handleSignUp={handleSignUp}
                handleLogin={handleLogin}
                handleReferModal={handleReferModal}
                handleRefer={handleReferClose}
                setToggleRefer={setToggleRefer}
              />
            </div>
          </div>
        )}

        {showLanguage && (
          // <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-black/50 flex justify-center items-center">
          // <div
          //   onClick={(e) => e.stopPropagation()}
          //   className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border  text-black   rounded-md"
          // >
          <LanguageModal handleLanguage={handleLanguage} />
          //   </div>
          // </div>
        )}

      </div>
    </>
  );
};

export default AppFooter;
