/* eslint-disable react/prop-types */
import { useEffect, useState } from "react";
import { FaHome } from "react-icons/fa";
import { IoHomeOutline } from "react-icons/io5";
import {
  MdKeyboardArrowDown,
  MdKeyboardArrowLeft,
  MdKeyboardArrowRight,
  MdKeyboardArrowUp,
} from "react-icons/md";
import MiniMobileSidebar from "../sidebar/MiniMobileSidebar";
import { useNavigate } from "react-router-dom";
import { useDispatch, useSelector } from "react-redux";
import { casinoListByCategory, defaultSetting, getCasinoProvider, getPromotionsOffer } from "../../redux/_reducers/_reducers";
import { toast } from "react-toastify";
import { IoIosArrowForward } from "react-icons/io";
import MiniGamesSidebar from "../sidebar/MiniGamesSidebar";
import { AiOutlineLoading3Quarters } from "react-icons/ai";
import MiniCasinoProvider from "../sidebar/MiniCasinoProvider";
import MiniGamesProvider from "../sidebar/MiniGamesProvider";
import Promotions from "../promotions/Promotions";
import LanguageModal from "../languageModal/LanguageModal";

const AppSidebar = ({ isSidebarClose }) => {
  const [isMobile, setIsMobile] = useState(false);
  const [openDropdown, setOpenDropdown] = useState(null);
  const [miniSidebar, setMiniSidebar] = useState(false);

  const [casinoProvider, setCasinoProvider] = useState(false);
  const [slotProvider, setSlotProvider] = useState(false);
  const [typeProvider, setTypeProvider] = useState("");
  const [nameProvider, setNameProvider] = useState("");

  const [apiData, setApiData] = useState([]);
  const [isLoading, setIsLoading] = useState(false);


  const [gameList, setGameList] = useState(false);
  const [casinoList, setCasinoList] = useState(false);

  const [casinoGamesList, setCasinoGamesList] = useState(false);
  const [slotGamesList, setSlotGamesList] = useState(false);

  const [tableGamesList, setTableGamesList] = useState(false);
  const [crashGamesList, setCrashGamesList] = useState(false);
  const [fishGamesList, setFishGamesList] = useState(false);
  const [arcadeGamesList, setArcadeGamesList] = useState(false);
  const [lotteryGamesList, setLotteryGamesList] = useState(false);


  const [contactUs, setContactUs] = useState(false);
  const dispatch = useDispatch();
  const { defaultSettingData } = useSelector((state) => state.authentication);
  const [showPromotions, setShowPromotions] = useState(false);

  const navigate = useNavigate();

  const handlePromotions = () => {
    setShowPromotions((prev) => !prev);
    dispatch(getPromotionsOffer())
  };

  const handleLanguage = () => {
    setShowLanguage((prev) => !prev);
  };

  const handleGetCasinoListByCategory = async (label) => {
    setIsLoading(true);
    const payload = {
      category: label,
      limit: 1000,
    };

    try {
      const response = await dispatch(casinoListByCategory(payload)).unwrap();
      if (response) {
        setApiData(response);
      } else {
        console.warn("No data found in response:", response);
        setApiData([]);
      }
    } catch (error) {
      console.error("API call failed:", error);
      setApiData([]);
    }
    setIsLoading(false);
  };

  const handleCasinoProvider = () => {
    setCasinoProvider(!casinoProvider);
    if (!casinoProvider) {
      dispatch(getCasinoProvider())
    }
  };

  const handleSlotProvider = (type, providerName) => {
    setSlotProvider(!slotProvider);
    setNameProvider(providerName);
    setTypeProvider(type);
  };

  const handleContantUS = () => {
    setContactUs((prev) => !prev);
    setGameList(false);
  };

  const handleGameList = () => {
    setGameList((prev) => !prev);
    setCasinoGamesList(false);
    setContactUs(false);
  };


  const handleCasinoGames = () => {
    setCasinoGamesList((prev) => !prev);
    setGameList(false);
    setSlotGamesList(false)
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleSlotGames = () => {
    setSlotGamesList((prev) => !prev);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleTableGames = () => {
    setTableGamesList((prev) => !prev);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleCrashGames = () => {
    setCrashGamesList((prev) => !prev);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleFishGames = () => {
    setFishGamesList((prev) => !prev);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleArcadeGames = () => {
    setArcadeGamesList((prev) => !prev);
    setFishGamesList(false);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleLotteryGames = () => {
    setLotteryGamesList((prev) => !prev);
    setArcadeGamesList(false);
    setFishGamesList(false);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleProviderClick = (type, providerName) => {
    window.location.href = `/casino-provider/${type}/${providerName}`;

  }

  const handleCasinoList = (id) => {
    setCasinoList(state => {
      if (state == id) {
        return null
      }
      else {
        return id
      }
    });
    setGameList(false);
    setContactUs(false);
  };

  const toggleDropdown = (id) => {
    setOpenDropdown(openDropdown === id ? null : id);
  };

  useEffect(() => {
    dispatch(defaultSetting());
  }, []);

  useEffect(() => {
    const handleResize = () => {
      setIsMobile(window.innerWidth < 1024);
    };
    handleResize();
    window.addEventListener("resize", handleResize);
    return () => {
      window.removeEventListener("resize", handleResize);
    };
  }, []);

  useEffect(() => {
    document.body.classList.add("sidebar-collapse");
  }, []);

  const handleToggle = () => {

    document.body.classList.toggle("sidebar-collapse");
    if (openDropdown) {
      setOpenDropdown(null);
    }
    if (gameList) {
      setGameList(false);
    }
    if (casinoList) {
      setCasinoList(false);
    }
    if (casinoGamesList) {
      setCasinoGamesList(false);
    }
    if (contactUs) {
      setContactUs(false);
    }
    setMiniSidebar(false);
    setCasinoProvider(false);
  };

  const [providers, setProviders] = useState([]);

  const { getCasinoProviderData } = useSelector(state => state.authentication);

  const [showLanguage, setShowLanguage] = useState(false);


  useEffect(() => {
    if (getCasinoProviderData && getCasinoProviderData.length > 0) {
      const updatedProviders = getCasinoProviderData.map((provider) => {
        let imageUrl = "/images/default.png";

        if (provider.provider_name === "AWC") imageUrl = "/assets/dashboard/provider-awcmsg.png";
        else if (provider.provider_name === "BETGAMES") imageUrl = "/assets/dashboard/provider-bg.png";
        else if (provider.provider_name === "CRASH88") imageUrl = "/assets/dashboard/provider-awcmpt.png";
        else if (provider.provider_name === "EZUGI") imageUrl = "/assets/dashboard/provider-evo.png";
        else if (provider.provider_name === "JiLi") imageUrl = "/assets/dashboard/provider-awcmjili.png";
        else if (provider.provider_name === "KINGMIDAS") imageUrl = "/assets/dashboard/provider-awcmkm.png";
        else if (provider.provider_name === "MAC88") imageUrl = "/assets/dashboard/provider-mg.png";
        else if (provider.provider_name === "RG") imageUrl = "/assets/dashboard/provider-awcmsg.png";
        else if (provider.provider_name === "SAP") imageUrl = "/assets/dashboard/provider-wm.png";
        else if (provider.provider_name === "SPRIBE") imageUrl = "/assets/dashboard/provider-jdbaspribe.png";
        else if (provider.provider_name === "SUNO") imageUrl = "/assets/dashboard/provider-awcmladyluck.png";
        return { ...provider, image: imageUrl };
      });
      setProviders(updatedProviders);
    }
  }, [getCasinoProviderData]);



  return (
    <>
      {showLanguage && (
        <LanguageModal handleLanguage={handleLanguage} />
      )}

      {miniSidebar && (
        <MiniMobileSidebar
          setIsSideBar={setMiniSidebar}
          isSideBar={miniSidebar}
          isSidebarClose={isSidebarClose}
        />
      )}

      {casinoProvider && (
        <MiniCasinoProvider
          setIsSideBar={setCasinoProvider}
          handleProviderClick={handleProviderClick}
          isSideBar={casinoProvider}
          providers={providers}
          isSidebarClose={isSidebarClose}
        />
      )}

      {slotProvider && (
        <MiniGamesProvider
          setIsSideBar={setCasinoProvider}
          handleProviderClick={handleProviderClick}
          isSideBar={slotProvider}
          isSidebarClose={isSidebarClose}
          type={typeProvider}
          name={nameProvider}
        />
      )}

      {showPromotions && (
        <div className="fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent flex justify-center items-center">
          <div
            onClick={(e) => e.stopPropagation()}
            className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border  text-black   rounded-md"
          >
            <Promotions handlePromotions={handlePromotions} />
          </div>
        </div>
      )}

      {/* Desktop Sidebar */}
      <div className="hidden lg:block  max-h-[98vh] scrollbar-hide overflow-y-auto overflow-x-hidden ">
        <div
          className={`flex ${!isSidebarClose ? "h-0 opacity-0 " : "h-[60px] opacity-100"
            } transition-all duration-300 w-full bg-[var(--dark-header)] justify-between items-center`}
        >
          <div
            onClick={() => handleToggle()}
            className="cursor-pointer flex h-full justify-center items-center  w-full bg-[var(--secondary)]"
          >
            <div
              onClick={() => handleToggle()}
              className="cursor-pointer flex justify-center items-center bg-[var(--dark-header)] w-10 rounded-full"
            >
              <span>
                <MdKeyboardArrowRight
                  onClick={() => handleToggle()}
                  className="text-white"
                  size={25}
                />
              </span>
            </div>
          </div>
        </div>
        <div
          className={`   ${isSidebarClose ? "h-0 opacity-0 " : "h-[60px] opacity-100"
            }  transition-all duration-700 flex items-center border-b border-[var(--light-header)]  `}
        >
          <div
            onClick={() => {
              navigate("/dashboard");
            }}
            className={`${isSidebarClose ? "hidden" : "flex"
              } cursor-pointer justify-start ml-7 text-white gap-5 margin items-center w-full h-full`}
          >
            {/* <IoHomeOutline size={20} /> */}
            <img
              src="/assets/dashboard/icon-home.png"
              alt=""
              className="w-8 h-8"
            />
            <span className="font-bold text-[17px]"> Home </span>
          </div>
          <div
            onClick={() => handleToggle()}
            className={`${isSidebarClose ? "left-[15px] rotate-180" : "left-[250px]"
              } transition-all duration-[700ms] cursor-pointer fixed  top-[15px]  -translate-x-1/2 flex justify-center items-center bg-[var(--dark-header)] w-10 rounded-full`}
          >
            <span>
              <MdKeyboardArrowLeft className="text-white" size={25} />
            </span>
          </div>
        </div>

        <div>
          {isSidebarClose && (
            <div
              onClick={() => toggleDropdown()}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center border-b-[1px] py-3 !border-[var(--light-header)]   text-white text-[20px]`}
            >
              <div
                onClick={() => {
                  navigate("/dashboard");
                }}
                className="flex gap-4"
              >
                <img
                  src="/assets/dashboard/icon-home.png"
                  alt=""
                  className="w-8 h-8"
                />{" "}
                <span
                  className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}
                >
                  HOME
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                <MdKeyboardArrowRight size={24} />
              </span>
            </div>
          )}

          <div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleGameList();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3] ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-sport.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Sports
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!gameList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${gameList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => {
                  window.location.href = `/inplay/${4}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/cricket.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">Cricket</span>
                </div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${1}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/sbo.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Football</div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${2}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/pinnacle.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Tennis</div>
              </div>
            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleCasinoGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-casino.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Casino
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!casinoGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${casinoGamesList ? "max-h-96" : "max-h-0"
                } overflow-y-auto mr-1 bg-[#f5f5f5]`}
            >
              {providers?.map((game) => (
                <div
                  key={game.eventId}
                  onClick={() => handleProviderClick("casino", game.provider_name)}
                  style={{ padding: "12px 12px 12px 40px" }}
                  className=" flex w-full  border-b gap-2  items-center overflow-y-auto py-3">
                  <img alt={game.provider_name} className="w-[30px] h-[30px]" src={game.image} />
                  <p className="md:my-0 text-sm my-1 whitespace-nowrap">{game.provider_name}</p>
                </div>
              ))}
            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleSlotGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-slot.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Slots
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!slotGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${slotGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("slots", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleTableGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-table.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Table
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!tableGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${tableGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("table", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleCrashGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-crash.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Crash
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!crashGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${crashGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("crash", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleFishGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-fish.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Fishing
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!fishGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${fishGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("fishing", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleArcadeGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-arcade.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Arcade
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!arcadeGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${arcadeGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("arcade", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleLotteryGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-lottery.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Lottery
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!lotteryGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${lotteryGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("lottery", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              onClick={() => toggleDropdown()}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3] ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex gap-2 whitespace-nowrap">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-affiliate.png"
                    alt=""
                    className="h-[26px] w-[26px] "
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Profile
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                handlePromotions();
                handleToggle();
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3] ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex gap-2 whitespace-nowrap">
                <div>
                  {" "}
                  <img
                    src="/footer_images/toolbar-icon-promotion.svg"
                    alt=""
                    className="h-[26px] w-[26px] "
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Promotions
                </span>
              </div>
            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleContantUS();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer hover:bg-[#1a79d3]  ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-3 text-white text-[20px]`}
            >
              <div className="flex gap-2 whitespace-nowrap">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-talk.png"
                    alt=""
                    className="h-7 "
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  ContactUS
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!contactUs ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] ${contactUs ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              {/* <div className=" flex w-full  border-b gap-2  items-center   py-3" style={{ padding: "12px 12px 12px 40px" }}>
                  <img
                    src="/mobilesidebarImages/icon-customer.png"
                    alt=""
                    className="h-5"
                  />
                  <div className="text-[16px] font-light">
                    Live Chat 24/7
                  </div>
                </div> */}
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.telegram"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Telegram Support</div>
              </div>
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.facebook"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Facebook Support</div>
              </div>
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.instagram"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Instagram Support</div>
              </div>
              {/* <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Telegram Channel
                  </a>
                </div>
                <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Facebook...
                  </a>
                </div>
                <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Support Email
                  </a>
                </div> */}
            </div>

          </div>
        </div>
      </div>

      {isMobile && (
        <div
          className={`fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm z-20 ${isSidebarClose ? "hidden" : "block"
            }`}
          onClick={handleToggle}
        ></div>
      )}
      <div
        className={`lg:hidden overflow-auto z-[99999] scrollbar-hide fixed top-0 left-0 h-screen bg-white  transform transition-transform duration-300 ${isSidebarClose ? "-translate-x-full" : "translate-x-0"
          }`}
        style={{ width: "190px" }}
      >
        <div className="h-screen bg-white lg:pb-0 overflow-y-auto">
          <div className="relative h-screen pb-20 overflow-y-auto">
            <div
              onClick={() => {
                {
                  navigate("/dashboard");
                }
                handleToggle();
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center"
            >
              <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                <FaHome />
              </div>{" "}
              Home
            </div>

            {/* <div className="w-full p-2 text-[15px] gap-3 flex items-center"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div> Home</div>
          <div className="w-full p-2 text-[15px] flex items-center gap-3"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div> Promotion</div>
          <div className="w-full p-2 text-[15px] flex items-center gap-3"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div>Sponsorship</div> */}
            {/* <div className="w-full p-2 text-[15px] flex items-center gap-3 border-b pb-4"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div>Leaderboard</div> */}
            <div className="text-[16px] font-semibold pt-2 p-2 pl-4 border-t  ">
              Games
            </div>
            {/* {MOBILE_SIDE_BAR?.games?.map((element, index) => {
              return (
                <div   onClick={() => setMiniSidebar(true)} className="w-full p-2 text-[15px] gap-3 flex items-center text-black">
                  <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                    {element?.icon}
                  </div>{" "}
                  {element?.label}
                </div>
              );
            })} */}

            <div
              onClick={() => setMiniSidebar(!miniSidebar)}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-sport.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Sports
              </div>
              <IoIosArrowForward className={miniSidebar ? "rotate-180" : ""} />
            </div>


            <div
              onClick={handleCasinoProvider}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-casino.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Casino
              </div>
              <IoIosArrowForward className={casinoProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("slots", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-slot.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Slots
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("table", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-table.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Table
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("crash", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-crash.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Crash
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("fishing", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-fish.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Fishing
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("arcade", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-arcade.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Arcade
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={() => handleSlotProvider("lottery", "JiLi")}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/assets/dashboard/icon-lottery.png"
                    alt=""
                    className="w-7 h-7"
                  />
                </div>{" "}
                Lottery
              </div>
              <IoIosArrowForward className={slotProvider ? "rotate-180" : ""} />
            </div>

            <div className="text-[16px] font-semibold pt-3 p-2 pl-4 border-t mt-2 ">
              Profile
            </div>

            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                {
                  navigate("/profile");
                }
                handleToggle();
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-affiliate.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              <span
                className={`text-[15px] font-[500] ${isSidebarClose ? "hidden" : ""
                  }`}
              >
                Profile
              </span>
            </div>

            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                {
                  handlePromotions();
                }
                handleToggle();
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-promotion.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              <span
                className={`text-[15px] font-[500] ${isSidebarClose ? "hidden" : ""
                  }`}
              >
                Promotions
              </span>
            </div>

            <div className="text-[16px] font-semibold pt-3 p-2 pl-4 border-t mt-2 ">
              Others
            </div>

            <div
              onClick={() => {
                {
                  handleLanguage();
                }
                handleToggle();
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black">

              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-language.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Language
            </div>

            {/* {MOBILE_SIDE_BAR?.others?.map((element, index) => {
              return (
                <div
                  className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
                  onClick={() => {
                    toggleDropdown(element?.id);
                  }}
                >
                  <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                    {element?.icon}
                  </div>{" "}
                  {element?.name}
                </div>
              );
            })} */}

            {/* <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                toggleDropdown();
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-talk.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              24/7 Live Chat
            </div> */}
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.telegram"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/mobiletelegram.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Telegram Support
            </div>
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.facebook"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-talk.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Facebook Support
            </div>
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.instagram"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-faq.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Instagram
            </div>
            {/* <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                toggleDropdown(element?.id);
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
              <img src="/mobilesidebarImages/mobiletelegram.png" alt=""  className="h-9"/>
              </div>{" "}
              Responsible Gaming
            </div> */}
          </div>
        </div>
      </div >
    </>
  );
};

export default AppSidebar;


export const gamesData = [
  {
    id: 5001,
    name: "Live Casino",
    payload: "live-casino",
    icon: "/casinoimages/111.png"
  },
  {
    id: 5002,
    name: "Slots",
    payload: "JiLi",
    icon: "/casinoimages/slot.png"
  },
  {
    id: 5003,
    name: "teen-patti",
    payload: "teen-patti",
    icon: "/casinoimages/20.png"
  },
  {
    id: 5004,
    name: "lucky7",
    payload: "lucky7",
    icon: "/casinoimages/27.png"
  },
  {
    id: 5005,
    name: "dragon-tiger",
    payload: "dragon-tiger",
    icon: "/casinoimages/23.png"
  },
  {
    id: 5006,
    name: "baccarat",
    payload: "baccarat",
    icon: "/casinoimages/22.png"
  },
  {
    id: 5007,
    name: "andar-bahar",
    payload: "andar-bahar",
    icon: "/casinoimages/26.png"
  },
  {
    id: 5008,
    name: "poker",
    payload: "poker",
    icon: "/casinoimages/21.png"
  }
];