import { useState } from 'react';
import { RxCross2 } from 'react-icons/rx';
import Login from '../login/Login';

const NotificationAlert = ({ setShowLogin, handleLogin }) => {

  return (
    <>

      <div className="flex w-full h-full ">


        <div className='w-full bg-transparent md:rounded-md '>

          <div className='flex justify-between text-white text-[19px] md:rounded-tr-md md:rounded-tl-md w-full items-center bg-[var(--primary)]  py-[10px] px-2'>
            Notification
            <RxCross2 className='text-white cursor-pointer' onClick={() => document.body.classList.remove("login_notification")} />
          </div>
          <div className=' py-6 px-3'>
            You have to login to play the game.
            If you do not have an account with us yet, just sign up with us. It is FREE!
          </div>


          <div className=' py-6 px-3'>
            <div
              className="flex w-full py-2 h-full text-white text-[15px] font-bold bg-[var(--primary)]  justify-center items-center"
              onClick={() => {
                handleLogin();
              }}
            >
              Go to Login
            </div>
          </div>

        </div >
      </div>
    </>

  );
};

export default NotificationAlert;