import { useState } from "react";
import { IoIosEyeOff, IoIosEye } from "react-icons/io";
import { useDispatch, useSelector } from "react-redux";
import { getPromotionsOffer, login } from "../../redux/_reducers/_reducers";
import { useNavigate } from "react-router-dom";
import { RxCross2 } from "react-icons/rx";
import settings from "../../domainConfig";
import { FaRegClock } from "react-icons/fa";
import PromotionDetails from "./PromotionDetails";

const Promotions = ({ handlePromotions }) => {
  const dispatch = useDispatch();
  const navigate = useNavigate();
  const { getPromotionsData } = useSelector(state => state.authentication);
  const [showPromotionModal, setShowPromotionModal] = useState(false);
  const [selectedPromotion, setSelectedPromotion] = useState(null);

  const handlePromotionDetails = (promotion) => {
    dispatch(getPromotionsOffer())
    setShowPromotionModal((prev) => !prev);
    setSelectedPromotion(promotion);
  };

  return (
    <>

      <PromotionDetails
        showModal={showPromotionModal}
        setShowModal={setShowPromotionModal}
        selectedPromotion={selectedPromotion}
      />

      <div className="h-[50px] absolute flex justify-between text-white text-[19px] rounded-tr-md rounded-tl-md w-full items-center bg-[var(--primary)]  py-[10px] px-2">
        <div></div>
        Promotions
        <RxCross2
          className="text-white cursor-pointer"
          onClick={() => handlePromotions()}
        />
      </div>

      <form
        className="px-3 mt-[50px] h-[calc(100%-50px)] overflow-y-auto bg-[#f5f5f5] "
      >
        <div className="py-4">

          <div className="flex justify-start items-center ">
            <input
              type="text"
              className="bg-white text-sm text-black p-2 w-full border-0 outline-none"
              placeholder="Promo Code"
              value=""
            />
            <button
              className=" top-0 right-0 px-4 py-1.5 text-sm text-white bg-[var(--primary)]">
              ADD
            </button>
          </div>
        </div>
        {getPromotionsData?.length > 0 ? (
          getPromotionsData?.map((item, index) => (
            <div key={index} className="mt-0 flex flex-col justify-start items-start bg-white relative pb-4">
              <div className="bg-[var(--light-header)] text-white absolute top-2 text-[12px] font-[600] left-2 p-1">NEW</div>
              <img
                src={`${settings?.IMAGE_URL}/payment/${item?.image}`}
                className="rounded-t-md "
                alt={item?.title}
              />
              <img src='/footer_images/promotion-bg.svg'
                className="-mt-1 w-[355px] h-[10px]"
                alt={item?.title}
              />

              <div className="text-[16px] text-left font-[600] p-2  ">{item?.title}</div>
              <div className=" flex justify-between items-center w-full">
                <div className="flex justify-center items-center gap-1.5 px-3 ">
                  <FaRegClock size={16} className="text-[var(--light-header)]" />
                  <p className="text-[14px] text-left">{item?.sub_title}</p>
                </div>
                <div
                  onClick={() => handlePromotionDetails(item)}
                  className="bg-[#005dac] rounded-[.2rem] text-white text-[13px] cursor-pointer font-[600] p-1 w-32 text-center ">Details</div>
              </div>
            </div>

          ))
        ) : (
          <p className="text-center col-span-full text-gray-800 font-[600] p-2">No Promotion Data available!!</p>
        )}
        <div className="flex justify-end items-center w-full pt-4">
          <button
            onClick={() => handlePromotions()}
            // onClick={() => window.location.href = `/dashboard`}
            className=" top-0 right-0 mr-4 px-2 py-1.5 text-sm rounded text-white bg-[var(--primary)]">
            Close
          </button>
        </div>
      </form>


    </>
  );
};

export default Promotions;