import AOS from "aos";
import "aos/dist/aos.css";
import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";


const MiniGamesSidebar = ({ setIsSideBar, isSideBar, isSidebarClose, setApiData, apiData }) => {
  // const [apiData, setApiData] = useState([]);

  const navigate = useNavigate()
  useEffect(() => {
    AOS.init();
    AOS.refresh();
  }, [isSideBar]);
  if (isSidebarClose) return null


  return (
    <>
      <div
        className={`  h-full bg-[#f9fcff] w-[130px] overflow-y-auto lg:hidden left-[190px] absolute transition-all duration-300 ease-in-out z-30`}
        onClick={(e) => e.stopPropagation()}
        data-aos="fade-right" style={{ boxShadow: 'inset 1px 0px 15px [#e4e6e9]' }}>
        {apiData?.length > 0 ? (
          apiData?.map((item, index) => (
            <button
              key={index}
              onClick={() => window.location.href = `/iframe-casino-new/${item?.provider_name}/${item?.game_id}`}
              className="flex flex-col justify-center items-center border-b px-4 py-2 ">
              <img alt={item?.provider_name} className="w-[80px] h-[47px]" src={item?.Image} />
              <p className="md:my-0 text-xs my-1 text-ellipsis">{item?.game_name}</p>
            </button>
          ))
        ) : (
          <p className="text-center col-span-full text-gray-500">No data available. Click a tab to load content.</p>
        )}
      </div>
    </>
  );
};

export default MiniGamesSidebar;
