import AOS from "aos";
import "aos/dist/aos.css";
import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";


const MiniMobileSidebar = ({ setIsSideBar, isSideBar, isSidebarClose }) => {

  const navigate = useNavigate()
  useEffect(() => {
    AOS.init();
    AOS.refresh();
  }, [isSideBar]);
  if (isSidebarClose) return null


  return (
    <>
      <div
        className={`  h-full bg-[#f9fcff] w-[100px] lg:hidden left-[190px] absolute transition-all duration-300 ease-in-out z-30`}
        onClick={(e) => e.stopPropagation()}
        data-aos="fade-right" style={{ boxShadow: 'inset 1px 0px 15px [#e4e6e9]' }}>
        <div onClick={() => { window.location.href = `/inplay/${4}`; }} className="flex flex-col  justify-center items-center border-b p-4 m-1">
          <img src="/mobilesidebarImages/cricket.png" className="h-[50px] " />
          Cricket
        </div>
        <div onClick={() => { window.location.href = `/inplay/${1}`; }} className="flex flex-col  justify-center items-center border-b p-4 m-1">
          <img src="/mobilesidebarImages/saba.png" className="h-[50px]" />
          Football
        </div>
        <div onClick={() => { window.location.href = `/inplay/${2}`; }} className="flex flex-col  justify-center items-center border-b p-4 m-1">
          <img src="/mobilesidebarImages/pinnacle.png" className="h-[50px]" />
          Tennis
        </div>
      </div>
    </>
  );
};

export default MiniMobileSidebar;
