
import Slider from 'react-slick';
import 'slick-carousel/slick/slick.css';
import 'slick-carousel/slick/slick-theme.css';
const LoginSlider = () => {
    const sliderData = [
    
        {
            gameName: 'slider',
            gameImg: '/loginImages/image_1.jpg',
        },
        {
            gameName: 'slider',
            gameImg: '/loginImages/image_2.jpg',
        },
        {
            gameName: 'slider',
            gameImg: '/loginImages/image_3.jpg',
        },
    
    ]
    const settings = {
        autoplay: true,
        autoplaySpeed: 2500,
        arrows: false,
        centerMode: false,
        slidesToShow: 8,
        slidesToScroll: 1,
        responsive: [
            {
                breakpoint: 2560,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 1440,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 600,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    initialSlide: 3
                }
            },
            {
                breakpoint: 480,
                settings: {
                    slidesToShow: 1,
                    autoplay: true,
                    slidesToScroll: 1
                }
            }
        ]
    };

    return (
        <>
            <section className="  py-1 mt-1">
                <Slider {...settings}>
                    {sliderData.map((item, index) => (
                        <div key={index} className="cursor-pointer">
                            <div
                             className='flex gap-4'>
                                 {/* href={item.gameLink} */}
                                <img src={item.gameImg} alt={item.gameName} className='px-0' />
                            </div>
                        </div>
                    ))}
                </Slider>
            </section>
        </>
    )
}
export default LoginSlider;


