import React, { useEffect, useState } from "react";
import { BsPencilFill } from "react-icons/bs";
import { IoMdSettings } from "react-icons/io";
import { RxCross1 } from "react-icons/rx";

const Stakes = ({ handleCross }) => {
  const [matchStack, setMatchStack] = useState([]);
  const [disableInputs, setDisableInputs] = useState(true);

  useEffect(() => {
    let storedMatchStack = localStorage.getItem("match_stack");

    const matchStackArray = storedMatchStack.split(",");
    setMatchStack(matchStackArray);
  }, []);

  const handleinputChange = (e, index) => {
    const newMatchStack = [...matchStack];
    newMatchStack[index] = e.target.value;
    setMatchStack(newMatchStack);
  };

  return (
    <div className="w-full h-full bg-white ">
      <div className="w-full  h-10  flex justify-between items-center  bg-[var(--primary)]  jus">
        <div className="flex text-white justify-center items-center gap-2">
          <IoMdSettings size={20} />
          <span>Settings</span>
        </div>
        <RxCross1
          onClick={() => {
            handleCross();
          }}
          size={20}
          className="mr-2 text-white font-bold"
        />
      </div>
      <div className="w-full bg-gray-700   flex justify-start ">
        <div className="p-1 text-white">Stakes</div>
      </div>
      <div className="p-2">
        <span className="text-[20px] m-2"> Quick Stakes </span>
        <div className="w-full grid grid-cols-4">
          {matchStack?.map((element, index) => {
            return (
              <input
                disabled={disableInputs}
                key={index}
                value={element}
                onChange={(e) => {
                  handleinputChange(e, index);
                }}
                className={` px-2 text-center py-1 m-2 border rounded-md ${
                  disableInputs ? "bg-[var(--primary)]  text-white" : "shadow-inner bg-white"
                }`}
              />
            );
          })}
        </div>
        {disableInputs && (
          <button
            onClick={() => setDisableInputs(false)}
            className="w-full  flex justify-center text-[15px] font-bold items-center border p-1 gap-4 rounded-md bg-[#e8ecef]"
          >
            {" "}
            Edit Stakes <BsPencilFill size={15} />
          </button>
        )}
        {!disableInputs && (
          <button
            onClick={() => {
              localStorage.setItem("match_stack", matchStack.join(","));
              setDisableInputs(true);
            }}
            className="w-full flex justify-center text-[15px] font-bold items-center border p-1 text-white  bg-[#02559b] rounded-lg"
          >
            <span className="text-[14px]">Ok</span>{" "}
          </button>
        )}
      </div>
    </div>
  );
};

export default Stakes;
