import { useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { useNavigate } from 'react-router-dom';
import { balanceTransfer } from '../../redux/_reducers/_reducers';
import settings from '../../domainConfig';
import { AiOutlineLoading3Quarters } from 'react-icons/ai';

const BalanceTransfer = () => {
    const [username, setUsername] = useState('');
    const [amount, setAmount] = useState('');
    const [errors, setErrors] = useState({});
    const [isLoading, setIsLoading] = useState(false);
    const dispatch = useDispatch();
    const navigate = useNavigate();
    // const signup_loading = useSelector((state) => state.auth.loading);

    const handleUsernameChange = (e) => {
        setUsername(e.target.value);
    };

    const handleAmountChange = (e) => {
        setAmount(e.target.value.replace(/\D/g, ''));
    };

    const handleSubmit = (e) => {
        e.preventDefault();
        setIsLoading(true);
        const validationErrors = {};

        if (!username || username.length < 4 || /\s/.test(username)) {
            validationErrors.username = 'Username must be at least 4 characters, no spaces allowed.';
        }
        if (!amount || isNaN(amount) || parseInt(amount) <= 0) {
            validationErrors.amount = 'Amount must be a valid positive number.';
        }
        if (Object.keys(validationErrors).length > 0) {
            setErrors(validationErrors);
        } else {
            const data = { username, amount };
            dispatch(balanceTransfer(data)).then((response) => {
                setIsLoading(false);
                if (!response.error) {
                    setUsername('');
                    setAmount('');
                    setErrors({});
                }
            });
        }
    };

    return (
        <>
            <div className='lg:w-1/3 mt-[50px] h-[calc(100%-50px)] w-full mx-auto'>
                <form className='px-4 overflow-y-auto overflow-x-hidden border bg-[var(--primary)] py-4 rounded' onSubmit={handleSubmit}>
                    <div className='mt-[5px] py-2 flex flex-col gap-3 justify-center items-center'>
                        <img src={settings.logo} className='h-[36px]' alt='Login Logo' />
                    </div>
                    <div className='flex flex-col gap-2 mt-8'>
                        <label className='text-white font-[600]'>Username</label>
                        <input
                            type='text'
                            className='bg-white text-sm rounded-md p-3 border-0 outline-none'
                            placeholder='4-5 char, allow numbers, no space'
                            value={username}
                            onChange={handleUsernameChange}
                        />
                        {errors.username && <div className="text-red-500 text-xs">{errors.username}</div>}
                    </div>

                    <div className='flex flex-col gap-2 mt-4'>
                        <label className='text-white font-[600]'>Amount</label>
                        <div className='flex gap-4 items-center bg-white text-sm rounded-md p-3 divide-x divide-gray-500'>
                            <input
                                type='text'
                                className='w-full border-0 outline-none h-full bg-transparent px-2'
                                placeholder='Enter Amount'
                                value={amount}
                                onChange={handleAmountChange}
                            />
                        </div>
                        {errors.amount && <div className="text-red-500 text-xs">{errors.amount}</div>}
                    </div>

                    <div className="mt-5 text-center flex justify-center items-center">
                        {/* <button
                            type="submit"
                            className="px-10 py-2 text-[14px] font-[500] bg-[#64cc2f] text-white rounded flex justify-center items-center gap-2"
                            disabled={isLoading}
                        >
                            {isLoading && 
                            <AiOutlineLoading3Quarters size={18} className="animate-spin text-white" />}
                            {isLoading ? 
                            'Processing...' : 'Submit'}
                        </button> */}
                        <button
                            type='submit'
                            disabled={!username || !amount}
                            className={`px-4 py-2 mt-5 rounded-md cursor-pointer ${(username && amount) ? 'bg-gradient-to-r from-[#82d856] to-[#5ab72a] via-[#5ab72a] bg-[length:200%_100%] bg-[position:left] text-white' : "bg-[#64cc2f] text-white"} `}
                        >
                            {isLoading ? <div className="loaderNewLogin"></div> : "Submit"}
                        </button>
                    </div>
                </form>
            </div>
        </>
    );
};

export default BalanceTransfer;