import { useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { useNavigate } from 'react-router-dom';
import { balanceTransfer } from '../../redux/_reducers/_reducers';
import settings from '../../domainConfig';
import { AiOutlineLoading3Quarters } from 'react-icons/ai';
import { FaUserCircle } from 'react-icons/fa';
import { SlUser } from 'react-icons/sl';
import { MdDriveFileRenameOutline, MdMailOutline, MdPhoneInTalk } from 'react-icons/md';

const Profile = () => {

    const userProfileData = JSON.parse(localStorage.getItem(`user`));

    const name = userProfileData?.name;
    const mobileNo = userProfileData?.mobile;
    const userName = userProfileData?.user_name;
    const email = userProfileData?.email;


    const [username, setUsername] = useState('');
    const [amount, setAmount] = useState('');
    const [errors, setErrors] = useState({});
    const [isLoading, setIsLoading] = useState(false);
    const dispatch = useDispatch();
    const navigate = useNavigate();
    // const signup_loading = useSelector((state) => state.auth.loading);

    const handleUsernameChange = (e) => {
        setUsername(e.target.value);
    };

    const handleAmountChange = (e) => {
        setAmount(e.target.value.replace(/\D/g, ''));
    };

    const handleSubmit = (e) => {
        e.preventDefault();
        setIsLoading(true);
        const validationErrors = {};

        if (!username || username.length < 4 || /\s/.test(username)) {
            validationErrors.username = 'Username must be at least 4 characters, no spaces allowed.';
        }
        if (!amount || isNaN(amount) || parseInt(amount) <= 0) {
            validationErrors.amount = 'Amount must be a valid positive number.';
        }
        if (Object.keys(validationErrors).length > 0) {
            setErrors(validationErrors);
        } else {
            const data = { username, amount };
            dispatch(balanceTransfer(data)).then((response) => {
                setIsLoading(false);
                if (!response.error) {
                    setUsername('');
                    setAmount('');
                    setErrors({});
                }
            });
        }
    };

    return (
        <>
            <div className='lg:w-1/3 mt-[50px] h-[calc(100%-50px)] w-full mx-auto'>
                <form className='px-4 overflow-y-auto overflow-x-hidden bg-[#eaeff8] border border-[var(--primary)] shadow-md py-8 rounded' onSubmit={handleSubmit}>
                    <div className='py-2 flex gap-3 justify-center items-center text-[#2d58bb] font-bold text-2xl'>
                        <FaUserCircle /> Profile Information
                    </div>

                    <div className='md:w-[70%] w-full mx-auto p-5 border shadow-md bg-white rounded-lg'>

                        <div className="w-full py-2 text-lg font-bold text-[var(--primary)] border-b flex gap-2 items-center">
                            {/* <img src="/headerImages/icon-email.svg" className='h-[36px]' alt='Login Logo' /> */}
                            <MdDriveFileRenameOutline className='text-[var(--primary)]' />
                            <span className='text-black'>Name - </span> {name}
                        </div>


                        <div className="w-full py-2 text-lg font-bold text-[var(--primary)] border-b flex gap-2 items-center">
                            {/* <img src="/headerImages/icon-email.svg" className='h-[36px]' alt='Login Logo' /> */}
                            <SlUser className='text-[var(--primary)]' />
                            <span className='text-black'>Username - </span> {userName}
                        </div>

                        <div className="w-full py-2 text-lg font-bold text-[var(--primary)] border-b flex gap-2 items-center">
                            {/* <img src="/headerImages/icon-email.svg" className='h-[36px]' alt='Login Logo' /> */}
                            <MdMailOutline className='text-[var(--primary)]' />
                            <span className='text-black'>Email - </span> {email}
                        </div>

                        <div className="w-full py-2 text-lg font-bold text-[var(--primary)] border-b flex gap-2 items-center">
                            {/* <img src="/headerImages/icon-email.svg" className='h-[36px]' alt='Login Logo' /> */}
                            <MdPhoneInTalk className='text-[var(--primary)]' />
                            <span className='text-black'>Mobile Number - </span> {mobileNo}
                        </div>

                    </div>
                    {/* <div className='flex flex-col gap-2 mt-8'>
                        <label className='text-white font-[600]'>Username</label>
                        <input
                            type='text'
                            className='bg-white text-sm rounded-md p-3 border-0 outline-none'
                            placeholder='4-5 char, allow numbers, no space'
                            value={username}
                            onChange={handleUsernameChange}
                        />
                        {errors.username && <div className="text-red-500 text-xs">{errors.username}</div>}
                    </div> */}

                    {/* <div className='flex flex-col gap-2 mt-4'>
                        <label className='text-white font-[600]'>Amount</label>
                        <div className='flex gap-4 items-center bg-white text-sm rounded-md p-3 divide-x divide-gray-500'>
                            <input
                                type='text'
                                className='w-full border-0 outline-none h-full bg-transparent px-2'
                                placeholder='Enter Amount'
                                value={amount}
                                onChange={handleAmountChange}
                            />
                        </div>
                        {errors.amount && <div className="text-red-500 text-xs">{errors.amount}</div>}
                    </div> */}

                    {/* <div className="mt-5 text-center flex justify-center items-center">
                        <button
                            type='submit'
                            disabled={!username || !amount}
                            className={`px-4 py-2 mt-5 rounded-md cursor-pointer ${(username && amount) ? 'bg-gradient-to-r from-[#82d856] to-[#5ab72a] via-[#5ab72a] bg-[length:200%_100%] bg-[position:left] text-white' : "bg-[#64cc2f] text-white"} `}
                        >
                            {isLoading ? <div className="loaderNewLogin"></div> : "Submit"}
                        </button>
                    </div> */}
                </form>
            </div>
        </>
    );
};

export default Profile;