# Installation
> `npm install --save @types/country-list`

# Summary
This package contains type definitions for country-list (https://github.com/fannarsh/country-list).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/country-list.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/country-list/index.d.ts)
````ts
export interface Country {
    code: string;
    name: string;
}

/**
 * Expects an array of code and country name pairs to add to the list. Doesn't return anything.
 */
export function overwrite(countries: Country[]): void;

/**
 * Expects a two-digit country code. Returns the name for that country. If not found, it returns undefined.
 */
export function getName(code: string): string | undefined;

/**
 * Expects the English country name. Returns the code for that country. If not found, it returns undefined.
 */
export function getCode(name: string): string | undefined;

/**
 * Returns an array of all country names.
 */
export function getNames(): string[];

/**
 * Returns an array of all country codes.
 */
export function getCodes(): string[];

/**
 * Returns a key-value object of all countries using the name as key.
 */
export function getNameList(): { [name: string]: string };

/**
 * Returns a key-value object of all countries using the code as key.
 */
export function getCodeList(): { [code: string]: string };

/**
 * Returns an array of all country information, in the same format as it gets imported.
 */
export function getData(): Country[];

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 15:11:36 GMT
 * Dependencies: none

# Credits
These definitions were written by [Kyle Roach](https://github.com/iRoachie), and [Adam Binford](https://github.com/Kimahriman).
