// hooks/useWhatsappRef.ts
import { useEffect, useState } from "react";
import { apiFetch }       from "../utils/api";

export interface WaRef {
  slug : string;
  phone: string;
  link : string;
}

/** Returns null while loading or when the staff has no referral row */
export const useWhatsappRef = (staffId?: number|null) => {
  const [waRef, setWaRef] = useState<WaRef|null>(null);

  useEffect(() => {
    if (!staffId) return;

    apiFetch<WaRef>(`/api/staff/${staffId}/whatsapp-ref`)
      .then(setWaRef)          // {slug,phone,link}
      .catch(() => setWaRef(null));
  }, [staffId]);

  return waRef;                // either WaRef or null
};
